var sOutput = validateFile("cbcgesentrate.xml");

WScript.Echo(sOutput);

function OttieniDimensioneFile(strFile)
{
	var fso = new ActiveXObject('Scripting.FileSystemObject');
	var file = fso.GetFile(strFile);
	var dimensioneFile = file.Size;
	return dimensioneFile;
}

function validateFile(strFile)
{
    // Create an XML DOMDocument object.
    var x = new ActiveXObject("MSXML2.DOMDocument.4.0");

    //Load and validate the specified file into the DOM.
    x.async = false;
    x.validateOnParse = true;
    x.resolveExternals = true;
    x.load(strFile);

    // Return validation results in message to the user.
    if (x.parseError.errorCode != 0)
    {
        return("Errore di validazione file: " + strFile + 
               "\n=====================" +
               "\nMotivo: " + x.parseError.reason + 
               "\nSorgente: " + x.parseError.srcText + 
               "\nLinea: " + x.parseError.line + "\n");
    }
    else {
	
		// controllo la data di delibera
		var giorno = x.selectSingleNode("//Copertina/DataDelibera/Giorno").text;
		var mese = x.selectSingleNode("//Copertina/DataDelibera/Mese").text;
		var anno = x.selectSingleNode("//Copertina/DataDelibera/Anno").text;
		if(!isDataValida(giorno, mese, anno)){
			return("Errore di validazione file: " + strFile +
					"\n==========================" +
					"\nMotivo: La data delibera immessa '"+giorno+"/"+mese+"/"+anno+"' non  valida");
		}
		// fine controllo data di delibera
	
		if(OttieniDimensioneFile(strFile)>3000000){
				
			return("Errore di validazione file: " + strFile +
				"\n==========================" +
				"\n La dimensione  maggiore di 3 Mb");
		}
		return("Validazione effettuata con successo: " +  strFile +
			   "\n===================================\n" 
			   );
	}
}

// controlla se la data inserita corrisponde a una data valida
function isDataValida(giorno, mese, anno)
{
	var mydate = new Date(anno, mese-1, giorno);
	// verifico che la data costruita sia identica a quella indicata (nota: in JS 29/02/2010 diventa 01/03/2010)
	if(mydate.getDate() != giorno || mydate.getMonth()+1 != mese || mydate.getFullYear() != anno){
		return false;
	}
	return true;
}